#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
uint8_t reg;

void sync (void) {
	EMU->SetPRG_ROM16(0x8, Latch::data &7 | reg <<3);
	EMU->SetPRG_ROM16(0xC, 7 | reg <<3);
	iNES_SetCHR_Auto8(0x0, 0);
	if (reg &0x08)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

BOOL MAPINT load (void) {
	Latch::load(sync, Latch::busConflictAND);
	return TRUE;
}

void MAPINT writeReg (int, int addr, int) {
	reg = addr;
	sync();
}

void MAPINT reset (RESET_TYPE resetType) {
	reg = 0;
	Latch::reset(resetType);
	EMU->SetCPUWriteHandler(0x5, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = Latch::saveLoad_D(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 437;
} // namespace

MapperInfo MapperInfo_437 = {
	&mapperNum,
	_T("TH2348"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};